/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.alternate_dimension;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.peripheral.alternate_dimension.ErrorTerrainGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.NormalSkylandGenerator;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.forge.events.ServerDimensionsLoadEvent;

public class AlternateDimensions {
    public static final ResourceKey<DimensionType> surfaceType = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("immersive_portals:surface_type"));
    public static final ResourceKey<Level> alternate1 = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("immersive_portals:alternate1"));
    public static final ResourceKey<Level> alternate2 = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("immersive_portals:alternate2"));
    public static final ResourceKey<Level> alternate3 = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("immersive_portals:alternate3"));
    public static final ResourceKey<Level> alternate4 = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("immersive_portals:alternate4"));
    public static final ResourceKey<Level> alternate5 = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("immersive_portals:alternate5"));

    public static void init() {
        MinecraftForge.EVENT_BUS.register(AlternateDimensions.class);
        IPGlobal.postServerTickSignal.connect(AlternateDimensions::tick);
    }

    @SubscribeEvent
    public static void onServerDimensionsLoad(ServerDimensionsLoadEvent event) {
        AlternateDimensions.initializeAlternateDimensions(event.generatorOptions, event.registryManager);
    }

    private static void initializeAlternateDimensions(WorldOptions worldOptions, RegistryAccess registryManager) {
        Registry registry = registryManager.m_175515_(Registries.f_256862_);
        long seed = worldOptions.m_245499_();
        if (!IPGlobal.enableAlternateDimensions) {
            return;
        }
        Holder surfaceTypeHolder = (Holder)registryManager.m_175515_(Registries.f_256787_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("immersive_portals:surface_type"))).orElseThrow(() -> new RuntimeException("Missing immersive_portals:surface_type"));
        Holder surfaceTypeBrightHolder = (Holder)registryManager.m_175515_(Registries.f_256787_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("immersive_portals:surface_type_bright"))).orElseThrow(() -> new RuntimeException("Missing immersive_portals:surface_type_bright"));
        DimensionAPI.addDimension((Registry<LevelStem>)registry, alternate1.m_135782_(), (Holder<DimensionType>)surfaceTypeBrightHolder, AlternateDimensions.createSkylandGenerator(registryManager, seed));
        DimensionAPI.addDimension((Registry<LevelStem>)registry, alternate2.m_135782_(), (Holder<DimensionType>)surfaceTypeHolder, AlternateDimensions.createSkylandGenerator(registryManager, seed + 1L));
        DimensionAPI.addDimension((Registry<LevelStem>)registry, alternate3.m_135782_(), (Holder<DimensionType>)surfaceTypeHolder, AlternateDimensions.createErrorTerrainGenerator(seed + 1L, registryManager));
        DimensionAPI.addDimension((Registry<LevelStem>)registry, alternate4.m_135782_(), (Holder<DimensionType>)surfaceTypeHolder, AlternateDimensions.createErrorTerrainGenerator(seed, registryManager));
        DimensionAPI.addDimension((Registry<LevelStem>)registry, alternate5.m_135782_(), (Holder<DimensionType>)surfaceTypeHolder, AlternateDimensions.createVoidGenerator(registryManager));
    }

    public static boolean isAlternateDimension(Level world) {
        ResourceKey key = world.m_46472_();
        return key == alternate1 || key == alternate2 || key == alternate3 || key == alternate4 || key == alternate5;
    }

    private static void syncWithOverworldTimeWeather(@Nullable ServerLevel world, ServerLevel overworld) {
        if (world == null) {
            return;
        }
        ((IEWorld)world).portal_setWeather(overworld.m_46722_(1.0f), overworld.m_46722_(1.0f), overworld.m_46661_(1.0f), overworld.m_46661_(1.0f));
    }

    public static ChunkGenerator createSkylandGenerator(RegistryAccess rm, long seed) {
        return NormalSkylandGenerator.create((HolderGetter<Biome>)rm.m_175515_(Registries.f_256952_).m_255303_(), (HolderGetter<DensityFunction>)rm.m_175515_(Registries.f_257040_).m_255303_(), (HolderGetter<NormalNoise.NoiseParameters>)rm.m_175515_(Registries.f_256865_).m_255303_(), (HolderGetter<NoiseGeneratorSettings>)rm.m_175515_(Registries.f_256932_).m_255303_(), (HolderGetter<MultiNoiseBiomeSourceParameterList>)rm.m_175515_(Registries.f_273919_).m_255303_(), seed);
    }

    public static ChunkGenerator createErrorTerrainGenerator(long seed, RegistryAccess rm) {
        return ErrorTerrainGenerator.create((HolderGetter<Biome>)rm.m_175515_(Registries.f_256952_).m_255303_(), (HolderGetter<NoiseGeneratorSettings>)rm.m_175515_(Registries.f_256932_).m_255303_(), (HolderGetter<MultiNoiseBiomeSourceParameterList>)rm.m_175515_(Registries.f_273919_).m_255303_());
    }

    public static ChunkGenerator createVoidGenerator(RegistryAccess rm) {
        Registry biomeRegistry = rm.m_175515_(Registries.f_256952_);
        Registry structureSets = rm.m_175515_(Registries.f_256998_);
        Holder.Reference plainsHolder = biomeRegistry.m_246971_(Biomes.f_48202_);
        FlatLevelGeneratorSettings flatChunkGeneratorConfig = new FlatLevelGeneratorSettings(Optional.empty(), (Holder)plainsHolder, List.of());
        flatChunkGeneratorConfig.m_70401_().add(new FlatLayerInfo(1, Blocks.f_50016_));
        flatChunkGeneratorConfig.m_70403_();
        return new FlatLevelSource(flatChunkGeneratorConfig);
    }

    private static void tick() {
        if (!IPGlobal.enableAlternateDimensions) {
            return;
        }
        ServerLevel overworld = McHelper.getServerWorld((ResourceKey<Level>)Level.f_46428_);
        MinecraftServer server = MiscHelper.getServer();
        AlternateDimensions.syncWithOverworldTimeWeather(server.m_129880_(alternate1), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.m_129880_(alternate2), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.m_129880_(alternate3), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.m_129880_(alternate4), overworld);
        AlternateDimensions.syncWithOverworldTimeWeather(server.m_129880_(alternate5), overworld);
    }
}

